﻿//////////////////////////////////////////////
// MeshDataLinkTracker.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Forward decl -----------------------------

namespace nkGraphics
{
	class EntityRenderLodSlot ;
	class Mesh ;
}

/// Includes ---------------------------------

// nkCommon
#include <nilkinsCommon/Patterns/SingletonClass.h>

// Standards
#include <unordered_map>
#include <unordered_set>

/// Class ------------------------------------

namespace nkGraphics
{
	class MeshDataLinkTracker final
	{
		public :

			// Management
			void addLink (Mesh* mesh, EntityRenderLodSlot* lodSlot) ;
			void removeLink (Mesh* mesh, EntityRenderLodSlot* lodSlot) ;

			// Utilities
			void onMeshUpdatedBounds (Mesh* mesh) ;
			void onMeshUpdatedLayout (Mesh* mesh) ;

		private :

			// Attributes
			// Memory tracking
			std::unordered_map<Mesh*, std::unordered_set<EntityRenderLodSlot*>> _links ;
	} ;
}